# ==============================================================
#  TPMail - Panduan Instalasi cPanel
# ==============================================================

Dokumen ini berisi langkah-langkah untuk deploy TPMail di cPanel.

## PRASYARAT

1. cPanel dengan Node.js Selector (versi 18.x atau lebih baru)
2. PostgreSQL Database
3. Domain dengan SSL
4. Akses SSH (recommended)

---

## STRUKTUR FILE

```
tpmail-backend/
├── dist/           # Compiled backend code
├── prisma/         # Database schema
├── package.json    
├── package-lock.json
└── .env.example    # Template environment

tpmail-admin/
├── .next/          # Compiled Next.js app
├── public/         # Static files
├── server.js       # Server entry point
├── package.json
└── node_modules/
```

---

## LANGKAH 1: SETUP DATABASE POSTGRESQL

1. Login ke cPanel
2. Buka "PostgreSQL Databases"
3. Buat database baru: `tpmail_db`
4. Buat user baru: `tpmail_user` dengan password kuat
5. Assign user ke database dengan ALL PRIVILEGES
6. Catat connection string:
   ```
   postgresql://tpmail_user:PASSWORD@localhost:5432/tpmail_db
   ```

---

## LANGKAH 2: DEPLOY BACKEND

### 2.1 Upload Files

1. Buka File Manager di cPanel
2. Buat folder: `/home/USERNAME/tpmail-backend`
3. Upload seluruh isi folder `tpmail-backend/` ke folder tersebut
4. Upload juga folder `node_modules` dari backend lokal (atau install via SSH)

### 2.2 Konfigurasi Environment

1. Rename `.env.example` menjadi `.env`
2. Edit file `.env`:
   ```
   DATABASE_URL="postgresql://tpmail_user:PASSWORD@localhost:5432/tpmail_db"
   JWT_SECRET="ganti-dengan-random-string-32-karakter"
   JWT_EXPIRES_IN="7d"
   NODE_ENV=production
   ```

### 2.3 Setup Node.js App

1. Buka "Setup Node.js App" di cPanel
2. Klik "Create Application"
3. Isi:
   - Node.js version: 18.x atau lebih baru
   - Application mode: Production
   - Application root: `/home/USERNAME/tpmail-backend`
   - Application URL: `api.yourdomain.com` (subdomain untuk API)
   - Application startup file: `dist/src/main.js`
4. Klik "Create"

### 2.4 Install Dependencies & Migrate Database

Via SSH atau cPanel Terminal:

```bash
cd /home/USERNAME/tpmail-backend

# Aktifkan virtual environment Node.js
source /home/USERNAME/nodevenv/tpmail-backend/18/bin/activate

# Install dependencies
npm install --production

# Generate Prisma Client
npx prisma generate

# Run database migration
npx prisma migrate deploy

# Seed database (buat admin user)
npx prisma db seed
```

### 2.5 Restart App

Di halaman Node.js App, klik "Restart"

### 2.6 Test

```bash
curl https://api.yourdomain.com/api/health
```

Expected response:
```json
{"status":"ok","service":"TPMail API","version":"1.0.0"}
```

---

## LANGKAH 3: DEPLOY ADMIN PANEL

### 3.1 Upload Files

1. Buat folder: `/home/USERNAME/tpmail-admin`
2. Upload seluruh isi folder `tpmail-admin/` ke folder tersebut

### 3.2 Setup Node.js App

1. Buka "Setup Node.js App" di cPanel
2. Klik "Create Application"
3. Isi:
   - Node.js version: 18.x atau lebih baru
   - Application mode: Production
   - Application root: `/home/USERNAME/tpmail-admin`
   - Application URL: `admin.yourdomain.com`
   - Application startup file: `server.js`
   - Environment variables:
     - `HOSTNAME`: `0.0.0.0`
     - `PORT`: `3000` (atau sesuai cPanel)
4. Klik "Create"

### 3.3 Konfigurasi API URL

PENTING: Sebelum deploy, pastikan API URL sudah diset ke production.

Edit file `tpmail-admin/server.js` atau set environment variable:
- API_URL: `https://api.yourdomain.com/api`

### 3.4 Restart App

Di halaman Node.js App, klik "Restart"

---

## LANGKAH 4: KONFIGURASI SUBDOMAIN & SSL

### 4.1 Buat Subdomain

Di cPanel → Subdomains:
- `api.yourdomain.com` → untuk Backend API
- `admin.yourdomain.com` → untuk Admin Panel

### 4.2 Setup SSL

1. Buka "SSL/TLS" di cPanel
2. Gunakan AutoSSL untuk generate certificate gratis
3. Atau install Let's Encrypt via cPanel

---

## LANGKAH 5: KONFIGURASI CORS (Jika Perlu)

Jika mengalami error CORS, edit `backend/src/main.ts` sebelum build:

```typescript
app.enableCors({
  origin: [
    'https://admin.yourdomain.com',
    'https://yourdomain.com',
  ],
  credentials: true,
});
```

Lalu rebuild dan upload ulang.

---

## CREDENTIALS DEFAULT

- **Admin Email**: admin@example.com
- **Admin Password**: admin123

⚠️ **PENTING**: Ganti password admin segera setelah login pertama!

---

## TROUBLESHOOTING

### Error: Cannot find module
```bash
cd /home/USERNAME/tpmail-backend
source /home/USERNAME/nodevenv/tpmail-backend/18/bin/activate
npm install
```

### Error: Database connection failed
1. Cek PostgreSQL running di cPanel
2. Pastikan DATABASE_URL benar di .env
3. Cek user punya akses ke database

### Error: Port already in use
cPanel mengatur port otomatis via Phusion Passenger.
Jangan hardcode port di environment.

### Admin Panel tidak bisa connect ke API
1. Cek Console browser untuk error
2. Pastikan SSL aktif di kedua subdomain
3. Cek CORS settings di backend

### 502 Bad Gateway
1. Cek logs di Node.js App
2. Pastikan startup file benar
3. Restart aplikasi

---

## CHECKLIST DEPLOYMENT

- [ ] PostgreSQL database dibuat
- [ ] User database dengan privileges
- [ ] Backend di-upload
- [ ] Backend .env dikonfigurasi
- [ ] Node.js App backend dibuat
- [ ] Prisma migrate dijalankan
- [ ] Prisma seed dijalankan
- [ ] API bisa diakses (test /api/health)
- [ ] Admin Panel di-upload
- [ ] Node.js App admin panel dibuat
- [ ] SSL aktif untuk kedua subdomain
- [ ] Test login admin panel
- [ ] Test generate email via API
- [ ] Ganti password admin

---

## SUPPORT

Jika mengalami kendala:
1. Cek error logs di cPanel
2. Pastikan semua dependencies terinstall
3. Verifikasi environment variables

© 2025 ArvoreCloud. All rights reserved.
